<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $transaction_id = $_POST['transaction'] ?? '';
    $price = $_POST['price'] ?? 0;

    include 'db.php';

    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    if (empty($transaction_id)) {
        echo "Transaction ID is required";
        exit;
    }

    // Find the request and status + user_id
    $stmt = $conn->prepare("SELECT status, phone FROM mobile_recharge_requests WHERE transaction_id = ?");
    $stmt->bind_param("s", $transaction_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        echo "Request not found";
        exit;
    }

    $row = $result->fetch_assoc();
    if ($row['status'] === 'Cancelled') {
        echo "Already cancelled";
        exit;
    }

    $phone = $row['phone'];

    // Cancel the request
    $stmtUpdate = $conn->prepare("UPDATE mobile_recharge_requests SET status = 'Cancelled' WHERE transaction_id = ?");
    $stmtUpdate->bind_param("s", $transaction_id);
    $stmtUpdate->execute();

    if ($stmtUpdate->affected_rows > 0) {
        // Update voucher_balance
        $stmtBalance = $conn->prepare("UPDATE user_list SET voucher_balance = voucher_balance + ? WHERE phone = ?");
        $stmtBalance->bind_param("ds", $price, $phone);
        $stmtBalance->execute();

        echo "Cancelled successfully";
        $stmtBalance->close();
    } else {
        echo "Failed to cancel";
    }

    $stmt->close();
    $stmtUpdate->close();
    $conn->close();
}
?>
