<?php
include 'db.php';

function getDownlineUsers($conn, $referId, $level, $maxLevel, &$result) {
    if ($level > $maxLevel) return;

    $stmt = $conn->prepare("SELECT * FROM user_list WHERE refer = ? ORDER BY id DESC");

    $stmt->bind_param("s", $referId);
    $stmt->execute();
    $res = $stmt->get_result();

    while ($row = $res->fetch_assoc()) {
        $row['level'] = $level;
        $result[] = $row;
        getDownlineUsers($conn, $row['user_id'], $level + 1, $maxLevel, $result);
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $userId = $_POST['user_id'];
    $maxLevel = 10;
    $result = [];

    getDownlineUsers($conn, $userId, 1, $maxLevel, $result);

    echo json_encode($result);
}
?>
