<?php
header('Content-Type: application/json');
include 'db.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $user_id = trim($_POST['user_id'] ?? '');

    if (empty($user_id)) {
        echo json_encode(['success' => false, 'message' => 'User ID is required.']);
        exit;
    }



    if ($conn->connect_error) {
        echo json_encode(['success' => false, 'message' => 'Database connection failed: ' . $conn->connect_error]);
        exit;
    }

    // Initialize response data
    $response_data = [
        'success' => true,
        'balance' => 0.00,
        'voucher_balance' => 0.00,
        'has_pending_withdrawal' => false,
        'pending_request_id' => '',
        'message' => 'Data fetched successfully.'
    ];

    // --- Fetch User Balances ---
    $stmt_balance = $conn->prepare("SELECT balance, voucher_balance FROM user_list WHERE user_id = ?");
    if (!$stmt_balance) {
        echo json_encode(['success' => false, 'message' => 'Balance query preparation failed: ' . $conn->error]);
        $conn->close();
        exit;
    }
    $stmt_balance->bind_param("s", $user_id);
    $stmt_balance->execute();
    $result_balance = $stmt_balance->get_result();

    if ($result_balance->num_rows > 0) {
        $user_balances = $result_balance->fetch_assoc();
        $response_data['balance'] = floatval($user_balances['balance']);
        $response_data['voucher_balance'] = floatval($user_balances['voucher_balance']);
    } else {
        // User not found, set balances to 0 and indicate failure
        $response_data['success'] = false;
        $response_data['message'] = 'User not found.';
        echo json_encode($response_data);
        $stmt_balance->close();
        $conn->close();
        exit;
    }
    $stmt_balance->close();

    // --- Check for Pending Withdrawals ---
    $stmt_pending = $conn->prepare("SELECT id FROM withdraw_request WHERE user_id = ? AND status = 'Pending' LIMIT 1");
    if (!$stmt_pending) {
        // If this query fails, it's not a critical error for the whole process, but log it
        // Or you might decide to set success to false based on your error handling policy
        error_log("Pending withdrawal query preparation failed: " . $conn->error);
    } else {
        $stmt_pending->bind_param("s", $user_id);
        $stmt_pending->execute();
        $result_pending = $stmt_pending->get_result();

        if ($result_pending->num_rows > 0) {
            $pending_request = $result_pending->fetch_assoc();
            $response_data['has_pending_withdrawal'] = true;
            $response_data['pending_request_id'] = $pending_request['id'];
        }
        $stmt_pending->close();
    }

    $conn->close();
    echo json_encode($response_data);

} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method. Only POST allowed.']);
}
?>