<?php
header('Content-Type: application/json');

include 'dbs.php';

if ($con->connect_error) {
    echo json_encode(['success' => false, 'message' => 'Database connection failed: ' . $con->connect_error]);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $user_id = trim($_POST['user_id'] ?? '');
    $status = trim($_POST['status'] ?? ''); // 'Pending', 'Verified', 'Cancelled'

    if (empty($user_id)) {
        echo json_encode(['success' => false, 'message' => 'User ID is required.']);
        $con->close();
        exit;
    }

    // Validate the status parameter
    if (!in_array($status, ['Pending', 'Verified', 'Cancelled'])) {
        echo json_encode(['success' => false, 'message' => 'Invalid status parameter.']);
        $con->close();
        exit;
    }

    // Prepare the SQL query
    $sql = "SELECT id, user_id, name, phone, wallet, paymentmethod, paymentnumber, amount, status, created_at 
            FROM withdraw_request 
            WHERE user_id = ? AND status = ? 
            ORDER BY created_at DESC";

    $stmt = $con->prepare($sql);
    if (!$stmt) {
        echo json_encode(['success' => false, 'message' => 'Query preparation failed: ' . $con->error]);
        $con->close();
        exit;
    }

    // Bind parameters and execute
    $stmt->bind_param("ss", $user_id, $status);
    $stmt->execute();
    $result = $stmt->get_result();

    $requests = [];
    if ($result) {
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $requests[] = $row;
            }
            echo json_encode(['success' => true, 'data' => $requests, 'message' => 'Requests fetched successfully.']);
        } else {
            echo json_encode(['success' => true, 'data' => [], 'message' => 'No requests found for this status.']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Query execution failed: ' . $stmt->error]);
    }

    $stmt->close();
    $con->close();

} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method. Only POST allowed.']);
}
?>