<?php

date_default_timezone_set('Asia/Dhaka'); // বাংলাদেশ টাইমজোন সেট
$datetime = date("Y-m-d H:i:s");

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = $_POST['name'] ?? '';
    $phone = $_POST['phone'] ?? '';
    $operator = $_POST['operator'] ?? '';
    $plan = $_POST['plan'] ?? '';
    $rechargenumber = $_POST['rechargenumber'] ?? '';
    $amount = floatval($_POST['amount'] ?? 0);
    $status = $_POST['status'] ?? 'Pending';

    include 'db.php';
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    // trxid বা transaction_id অটো জেনারেট করতে পারো, নিচে উদাহরণ
    $transaction_id = uniqid('trx_');

    $stmt = $conn->prepare("INSERT INTO mobile_recharge_requests (transaction_id, name, phone, operator, plan, rechargenumber, amount, status, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");

// bind_param টাইপ স্ট্রিং 8 অক্ষর হবে: s s s s s s d s
$stmt->bind_param("ssssssdss", $transaction_id, $name, $phone, $operator, $plan, $rechargenumber, $amount, $status,$datetime);

    if ($stmt->execute()) {
        echo "রিচার্জ রিকুয়েস্ট সফলভাবে সাবমিট হয়েছে. Transaction ID: " . $transaction_id;
    } else {
        echo "Error: " . $stmt->error;
    }

    $stmt->close();
    $conn->close();
}
?>
