<?php
// your_api.php

header('Content-Type: application/json');

include 'db.php';
if ($conn->connect_error) {
    die(json_encode(["status" => "error", "message" => "Connection failed"]));
}

// POST data নিন
$amount = $_POST['amount'] ?? '';
$phone = $_POST['phone'] ?? '';
$trxid = $_POST['trxid'] ?? '';
$date = $_POST['date'] ?? '';

if (!$amount || !$phone || !$trxid || !$date) {
    echo json_encode(["status" => "error", "message" => "Missing parameters"]);
    exit;
}

$sql = "INSERT INTO transactions (amount, phone, trxid, date) VALUES (?, ?, ?, ?)";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ssss", $amount, $phone, $trxid, $date);

if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "Transaction saved"]);
} else {
    echo json_encode(["status" => "error", "message" => "Insert failed"]);
}

$stmt->close();
$conn->close();
?>
