<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $transaction_id = $_POST['transaction'] ?? '';

    include 'db.php';
    if (!$conn) {
        die("Connection failed: " . mysqli_connect_error());
    }
    
    date_default_timezone_set('Asia/Dhaka');
    $time_format = date("Y-m-d H:i:s");
    
    mysqli_query($con, "SET time_zone = '+06:00'");


    if (empty($transaction_id)) {
        echo "Transaction ID is required";
        exit;
    }

    // 1. Get Recharge Record
    $stmt = $conn->prepare("SELECT * FROM mobile_recharge_requests WHERE transaction_id = ?");
    $stmt->bind_param("s", $transaction_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows == 0) {
        echo "Recharge request not found";
        exit;
    }

    $recharge = $result->fetch_assoc();

    if ($recharge['status'] === 'Verified') {
        echo "Already verified";
        exit;
    }

    // 2. Set status Verified
    $stmtUpdate = $conn->prepare("UPDATE mobile_recharge_requests SET status = 'Verified' WHERE transaction_id = ?");
    $stmtUpdate->bind_param("s", $transaction_id);
    $stmtUpdate->execute();

    $phone = $recharge['phone'];
    $recharge_number = $recharge['rechargenumber'];
    $amount = floatval($recharge['amount']);

    // 3. Get user_id from phone
    $stmtUid = $conn->prepare("SELECT user_id FROM user_list WHERE phone = ?");
    $stmtUid->bind_param("s", $phone);
    $stmtUid->execute();
    $resUid = $stmtUid->get_result();
    $userData = $resUid->fetch_assoc();
    $user_id = $userData['user_id'] ?? '';
    $stmtUid->close();

    if (empty($user_id)) {
        echo "User ID not found for phone: $phone";
        exit;
    }

    // 4. Commission Calculation
    $self_commission = round($amount * 0.02, 2);
    
    // পরিবর্তন শুরু: ১০ লেভেলের জন্য নতুন কমিশন শতাংশ ও হিসাব
    $referral_percentages = [30, 20, 15, 10, 8, 3.4, 3.4, 3.4, 3.4, 3.4]; // % per level
    $total_referral_commission = round($amount * 0.005, 4);
    $referral_commissions = [];
    foreach ($referral_percentages as $percent) {
        $referral_commissions[] = round($total_referral_commission * ($percent / 100), 4);
    }
    // পরিবর্তন শেষ

    $company_commission = round($amount * 0.005, 2);
    $company_user_id = "COMPANY123"; // Ensure this exists in user_list

    // 5. Give self commission
    $stmtSelf = $conn->prepare("UPDATE user_list SET balance = balance + ? WHERE user_id = ?");
    $stmtSelf->bind_param("ds", $self_commission, $user_id);
    $stmtSelf->execute();

    $stmtSelfHist = $conn->prepare("INSERT INTO commission_history (user_id, from_user_id, phone, amount, source, type, created_at)
                                    VALUES (?, ?, ?, ?, 'Mobile Recharge', 'Self', ?)");
    $stmtSelfHist->bind_param("sssds", $user_id, $user_id, $recharge_number, $self_commission,$time_format);
    $stmtSelfHist->execute();

    // 6. Referral commission distribution (up to 10 levels)
    $current_user = $user_id;

    for ($level = 1; $level <= 10; $level++) {
        // Get referrer of current user
        $stmtRef = $conn->prepare("SELECT refer FROM user_list WHERE user_id = ?");
        $stmtRef->bind_param("s", $current_user);
        $stmtRef->execute();
        $resRef = $stmtRef->get_result();

        if ($resRef->num_rows == 0) break;

        $row = $resRef->fetch_assoc();
        $referrer = $row['refer'];
        $stmtRef->close();

        if (empty($referrer)) break;

        // পরিবর্তন শুরু: লেভেল অনুযায়ী কমিশন অ্যাসাইন
        $commission_amount = $referral_commissions[$level - 1];
        // পরিবর্তন শেষ

        // Update referrer's balance
        $stmtUpdateRef = $conn->prepare("UPDATE user_list SET balance = balance + ? WHERE user_id = ?");
        $stmtUpdateRef->bind_param("ds", $commission_amount, $referrer);
        $stmtUpdateRef->execute();

        // Insert commission history for referrer
        $stmtHistRef = $conn->prepare("INSERT INTO commission_history (user_id, from_user_id, phone, amount, source, type, created_at)
                                       VALUES (?, ?, ?, ?, 'Mobile Recharge', 'Referral', ?)");
        $stmtHistRef->bind_param("sssds", $referrer, $user_id, $recharge_number, $commission_amount,$time_format);
        $stmtHistRef->execute();

        $current_user = $referrer;
    }

    // 7. Company commission
    $stmtCompany = $conn->prepare("UPDATE user_list SET balance = balance + ? WHERE user_id = ?");
    $stmtCompany->bind_param("ds", $company_commission, $company_user_id);
    $stmtCompany->execute();

    $stmtCompanyHist = $conn->prepare("INSERT INTO commission_history (user_id, from_user_id, phone, amount, source, type, created_at)
                                       VALUES (?, ?, ?, ?, 'Mobile Recharge', 'Company', NOW())");
    $stmtCompanyHist->bind_param("sssd", $company_user_id, $user_id, $recharge_number, $company_commission);
    $stmtCompanyHist->execute();

    echo "Recharge verified and commissions distributed successfully.";

    // Cleanup
    $stmtUpdate->close();
    $stmtSelf->close();
    $stmtSelfHist->close();
    $stmtCompany->close();
    $stmtCompanyHist->close();
    $conn->close();
}
?>
