<?php

date_default_timezone_set('Asia/Dhaka'); // বাংলাদেশ টাইমজোন সেট
$datetime = date("Y-m-d H:i:s");
header('Content-Type: application/json');

// Database connection parameters - !!! IMPORTANT: Use environment variables or a secure configuration for production !!!
// For demonstration, these are kept here, but serious applications should avoid this.




if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    // Input data received from the POST request
    $user_id = trim($_POST['user_id'] ?? '');
    $name = trim($_POST['name'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    $wallet = trim($_POST['wallet'] ?? '');
    $paymentmethod = trim($_POST['paymentmethod'] ?? '');
    $paymentnumber = trim($_POST['paymentnumber'] ?? '');
    $status = trim($_POST['status'] ?? 'Pending'); // Default status to Pending if not provided

    // Clean and convert amount to float
    $amount_str = trim($_POST['amount'] ?? '0'); // Default to '0' if not set
    // Remove all characters that are not digits or a decimal point
    $cleaned_amount_str = preg_replace('/[^0-9.]/', '', $amount_str);
    $expected_amount = trim($_POST['expected_amount'] ?? '');
    // Convert to float, ensure it's not empty before converting
    $amount = !empty($cleaned_amount_str) ? floatval($cleaned_amount_str) : 0.00;

    // Validate essential inputs (you can add more validation if needed)
    if (empty($user_id) || empty($name) || empty($phone) || empty($wallet) || empty($paymentmethod) || empty($paymentnumber) || $amount <= 0) {
        echo json_encode(['success' => false, 'message' => 'Missing or invalid required data.']);
        exit;
    }

    // Database connection
   include 'dbs.php';

    if ($con->connect_error) {
        echo json_encode(['success' => false, 'message' => 'Database connection failed: ' . $con->connect_error]);
        exit;
    }

    // Prepared statement to prevent SQL Injection
    $stmt = $con->prepare("INSERT INTO withdraw_request (user_id, name, phone, wallet, paymentmethod, paymentnumber, amount,expected_amount, status,created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?,?)");

    if (!$stmt) {
        echo json_encode(['success' => false, 'message' => 'Statement preparation failed: ' . $con->error]);
        $con->close();
        exit;
    }

    // Bind parameters: "ssssssdss" -> s=string, d=double/float
    $stmt->bind_param("ssssssdsss", $user_id, $name, $phone, $wallet, $paymentmethod, $paymentnumber, $amount, $expected_amount, $status,$datetime);

    // Execute statement
    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Withdraw request has been submitted successfully.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to submit request: ' . $stmt->error]);
    }

    // Close statement and connection
    $stmt->close();
    $con->close();

} else {
    // Handle non-POST requests
    echo json_encode(['success' => false, 'message' => 'Invalid request method. Only POST requests are allowed.']);
}
?>