<?php
include 'db.php';

if (isset($_POST['user_id']) && isset($_POST['balance'])) {
    $user_id = $_POST['user_id'];
    $balance = (float) $_POST['balance'];

    // Validate
    if ($balance <= 0) {
        echo "Invalid balance amount";
        exit;
    }

    // Query to update voucher_balance by adding new balance
    $sql = "UPDATE user_list SET voucher_balance = voucher_balance + ? WHERE user_id = ?";
    $stmt = $conn->prepare($sql);

    if ($stmt) {
        $stmt->bind_param("ds", $balance, $user_id);
        if ($stmt->execute()) {
            echo "Balance added successfully";
        } else {
            echo "Failed to add balance";
        }
        $stmt->close();
    } else {
        echo "SQL error";
    }

    $conn->close();
} else {
    echo "Required fields missing";
}
?>
