<?php

date_default_timezone_set('Asia/Dhaka'); // বাংলাদেশ টাইমজোন সেট
$datetime = date("Y-m-d H:i:s");
// Raw JSON ইনপুট রিড
$input = file_get_contents("php://input");
$data = json_decode($input, true);

// যদি JSON invalid হয়
if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(400);
    echo json_encode(["error" => "Invalid JSON"]);
    exit;
}

// ডেটা বের করা
$name           = $data['name'] ?? '';
$phone          = $data['phone'] ?? '';
$offername      = $data['offername'] ?? '';
$price          = floatval($data['price'] ?? 0);
$rechargenumber = $data['rechargenumber'] ?? '';
$cashback       = floatval($data['cashback'] ?? 0);
$time           = $data['time'] ?? '';
$status         = $data['status'] ?? 'Pending';

// MySQL কানেকশন
include 'db.php';
mysqli_set_charset($conn, "utf8");

if (!$conn) {
    http_response_code(500);
    echo json_encode(["error" => "Database connection failed"]);
    exit;
}

// ট্রানজেকশন আইডি
$transaction_id = uniqid('trx_');

// Prepare
$stmt = $conn->prepare("INSERT INTO drive_offer_requests (
    transaction_id, name, phone, offername, price, rechargenumber, cashback, time, status, created_at
) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

$stmt->bind_param("sssssdssss", $transaction_id, $name, $phone, $offername, $price, $rechargenumber, $cashback, $time, $status,$datetime);

if ($stmt->execute()) {
    echo json_encode(["success" => true, "transaction_id" => $transaction_id]);
} else {
    http_response_code(500);
    echo json_encode(["error" => "Database insert failed", "details" => $stmt->error]);
}

$stmt->close();
$conn->close();
?>