<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $transaction_id = $_POST['transaction'] ?? '';

   include 'db.php';
    if (!$conn) {
        die("Connection failed: " . mysqli_connect_error());
    }
    
    date_default_timezone_set('Asia/Dhaka');
    $time_format = date("Y-m-d H:i:s");

    if (empty($transaction_id)) {
        echo "Transaction ID is required";
        exit;
    }

    // 1. Get Recharge Record
    $stmt = $conn->prepare("SELECT * FROM drive_offer_requests WHERE transaction_id = ?");
    $stmt->bind_param("s", $transaction_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows == 0) {
        echo "Recharge request not found";
        exit;
    }

    $recharge = $result->fetch_assoc();

    if ($recharge['status'] === 'Verified') {
        echo "Already verified";
        exit;
    }

    // 2. Set status Verified
    $stmtUpdate = $conn->prepare("UPDATE drive_offer_requests SET status = 'Verified' WHERE transaction_id = ?");
    $stmtUpdate->bind_param("s", $transaction_id);
    $stmtUpdate->execute();

    $phone = $recharge['phone'];
    $recharge_number = $recharge['rechargenumber'];

    // এখানে amount এর মান তোমার আগের কোড মত যেটা cashback সেটাই নেবো
    $cashback = floatval($recharge['cashback']); // current user পুরো cashback পাবে

    // 3. Get user_id from phone
    $stmtUid = $conn->prepare("SELECT user_id FROM user_list WHERE phone = ?");
    $stmtUid->bind_param("s", $phone);
    $stmtUid->execute();
    $resUid = $stmtUid->get_result();
    $userData = $resUid->fetch_assoc();
    $user_id = $userData['user_id'] ?? '';
    $stmtUid->close();

    if (empty($user_id)) {
        echo "User ID not found for phone: $phone";
        exit;
    }

    // 4. Give full cashback to current user
    $stmtCashback = $conn->prepare("UPDATE user_list SET balance = balance + ? WHERE user_id = ?");
    $stmtCashback->bind_param("ds", $cashback, $user_id);
    $stmtCashback->execute();

// Log cashback transaction
$stmtCashbackHist = $conn->prepare("INSERT INTO commission_history (user_id, from_user_id, phone, amount, source, type, created_at) VALUES (?, ?, ?, ?, 'Drive Offer', 'Cashback', ?)");
$stmtCashbackHist->bind_param("sssds", $user_id, $user_id, $recharge_number, $cashback, $time_format);
$stmtCashbackHist->execute();

    // 5. Referral commission distribution based on extra 10% of cashback (company এর টাকা থেকে দিবে)
    $extra_commission_total = round($cashback * 0.10, 4); // company থেকে extra 10% (cashback এর উপর)
    $level_percentages = [
        1 => 0.02,    // 2%
        2 => 0.0175,  // 1.75%
        3 => 0.015,   // 1.5%
        4 => 0.0125,  // 1.25%
        5 => 0.01,    // 1%
        6 => 0.008,   // 0.8%
        7 => 0.006,   // 0.6%
        8 => 0.005,   // 0.5%
        9 => 0.004,   // 0.4%
        10 => 0.002   // 0.2%
    ];

    $current_user = $user_id;

    for ($level = 1; $level <= 10; $level++) {
        // get refer id of current user
        $stmtRef = $conn->prepare("SELECT refer FROM user_list WHERE user_id = ?");
        $stmtRef->bind_param("s", $current_user);
        $stmtRef->execute();
        $resRef = $stmtRef->get_result();

        if ($resRef->num_rows == 0) {
            $stmtRef->close();
            break;
        }

        $row = $resRef->fetch_assoc();
        $referrer = $row['refer'];
        $stmtRef->close();

        if (empty($referrer)) break;

        $commission_for_level = round($extra_commission_total * $level_percentages[$level], 4);

        // Update referrer's balance
        $stmtUpdateRef = $conn->prepare("UPDATE user_list SET balance = balance + ? WHERE user_id = ?");
        $stmtUpdateRef->bind_param("ds", $commission_for_level, $referrer);
        $stmtUpdateRef->execute();

  // Insert commission history for referrer
$stmtHistRef = $conn->prepare("INSERT INTO commission_history (user_id, from_user_id, phone, amount, source, type, created_at) VALUES (?, ?, ?, ?, 'Drive Offer', 'Referral', ?)");
$stmtHistRef->bind_param("sssds", $referrer, $user_id, $recharge_number, $commission_for_level, $time_format);
$stmtHistRef->execute();

        $current_user = $referrer;
    }

    echo "Recharge verified and commissions distributed successfully.";

    // Close statements
    $stmtUpdate->close();
    $stmtCashback->close();
    $stmtCashbackHist->close();

    $conn->close();
}
?>
