<?php
header('Content-Type: application/json');

// --- Database Configuration (Replace with your actual credentials) ---
include 'db.php';



if ($conn->connect_error) {
    // Log the actual error but send a generic message to the client for security
    error_log('Database connection failed: ' . $conn->connect_error);
    echo json_encode(['success' => false, 'message' => 'Database connection failed. Please try again later.']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $operator = trim($_POST['operator'] ?? '');

    // --- Input Validation ---
    if (empty($operator)) {
        echo json_encode(['success' => false, 'message' => 'Operator name is required.']);
        $conn->close();
        exit;
    }

    // Optional: Validate operator against a predefined list for added security/robustness
    // $allowedOperators = ['Grameenphone', 'Robi', 'Banglalink', 'Airtel', 'Teletalk']; // Add all your valid operators
    // if (!in_array($operator, $allowedOperators)) {
    //     echo json_encode(['success' => false, 'message' => 'Invalid operator provided.']);
    //     $conn->close();
    //     exit;
    // }

    // Prepare the SQL query
    $sql = "SELECT name, price, cashback, validity, operator
            FROM drive_offers
            WHERE operator = ?";

    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        // Log the actual error but send a generic message to the client
        error_log('Query preparation failed: ' . $con->error);
        echo json_encode(['success' => false, 'message' => 'Failed to prepare offer data. Please try again later.']);
        $conn->close();
        exit;
    }

    // Bind parameters: "s" for a single string parameter (the operator)
    $stmt->bind_param("s", $operator);
    $stmt->execute();
    $result = $stmt->get_result();

    $offers = [];
    if ($result) {
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $offers[] = $row;
            }
            echo json_encode(['success' => true, 'data' => $offers, 'message' => 'Drive offers fetched successfully.']);
        } else {
            // Provide a clear message when no offers are found
            echo json_encode(['success' => true, 'data' => [], 'message' => 'No drive offers found for this operator.']);
        }
    } else {
        // Log the actual error but send a generic message to the client
        error_log('Query execution failed: ' . $stmt->error);
        echo json_encode(['success' => false, 'message' => 'Failed to retrieve offers. Please try again later.']);
    }

    $stmt->close();
    $conn->close();

} else {
    // Handle non-POST requests
    echo json_encode(['success' => false, 'message' => 'Invalid request method. Only POST allowed.']);
}
?>