<?php
header('Content-Type: text/html; charset=utf-8');

include 'db.php';

mysqli_set_charset($conn, "utf8mb4");

if ($conn->connect_error) {
    echo json_encode(['success' => false, 'message' => 'Database connection failed: ' . $conn->connect_error]);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $status = trim($_POST['status'] ?? ''); // 'Pending', 'Verified', 'Cancelled'


    // Validate the status parameter
    if (!in_array($status, ['Pending', 'Verified', 'Cancelled'])) {
        echo json_encode(['success' => false, 'message' => 'Invalid status parameter.']);
        $conn->close();
        exit;
    }

    // Prepare the SQL query
    $sql = "SELECT id, transaction_id, name, phone,offername,price,rechargenumber,cashback,time,status, created_at 
            FROM drive_offer_requests 
            WHERE status = ? 
            ORDER BY created_at DESC";

    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        echo json_encode(['success' => false, 'message' => 'Query preparation failed: ' . $conn->error]);
        $conn->close();
        exit;
    }

    // Bind parameters and execute
    $stmt->bind_param("s", $status);
    $stmt->execute();
    $result = $stmt->get_result();

    $requests = [];
    if ($result) {
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $requests[] = $row;
            }
            echo json_encode(['success' => true, 'data' => $requests, 'message' => 'Requests fetched successfully.']);
        } else {
            echo json_encode(['success' => true, 'data' => [], 'message' => 'No requests found for this status.']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Query execution failed: ' . $stmt->error]);
    }

    $stmt->close();
    $conn->close();

} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method. Only POST allowed.']);
}
?>