<?php
header("Content-Type: application/json");

include 'db.php';
if ($conn->connect_error) {
    echo json_encode(["success" => false, "message" => "Database connection failed"]);
    exit();
}

$user_id = $_POST['user_id'] ?? '';

if (empty($user_id)) {
    echo json_encode(["success" => false, "message" => "User ID is required"]);
    exit();
}

date_default_timezone_set("Asia/Dhaka");
$today = date("Y-m-d");
$seven_days_ago = date("Y-m-d", strtotime("-6 days")); // আজসহ ৭ দিন
$month_start = date("Y-m-01");
$yesterday = date("Y-m-d", strtotime("-1 day")); // গতকাল

function get_income($conn, $table, $user_id, $start_date, $end_date) {
    $stmt = $conn->prepare("SELECT IFNULL(SUM(amount), 0) AS total_income FROM $table WHERE user_id = ? AND DATE(created_at) BETWEEN ? AND ?");
    $stmt->bind_param("sss", $user_id, $start_date, $end_date);
    $stmt->execute();
    $result = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    return (float)$result['total_income'];
}

$today_income = get_income($conn, "commission_history", $user_id, $today, $today) 
                + get_income($conn, "commissions", $user_id, $today, $today);

$last_7_days_income = get_income($conn, "commission_history", $user_id, $seven_days_ago, $today) 
                      + get_income($conn, "commissions", $user_id, $seven_days_ago, $today);

$one_month_income = get_income($conn, "commission_history", $user_id, $month_start, $today) 
                    + get_income($conn, "commissions", $user_id, $month_start, $today);

// ✅ নতুন অংশ: Yesterday income
$yesterday_income = get_income($conn, "commission_history", $user_id, $yesterday, $yesterday)
                    + get_income($conn, "commissions", $user_id, $yesterday, $yesterday);

// ✅ নতুন অংশ: Total income (now - very early date)
$start_date_all = "2000-01-01";
$total_income = get_income($conn, "commission_history", $user_id, $start_date_all, $today)
                + get_income($conn, "commissions", $user_id, $start_date_all, $today);

$stmtBal = $conn->prepare("SELECT balance, voucher_balance FROM user_list WHERE user_id = ?");
$stmtBal->bind_param("s", $user_id);
$stmtBal->execute();
$resBal = $stmtBal->get_result();
$balData = $resBal->fetch_assoc();

$balance = $balData['balance'] ?? 0;
$voucher_balance = $balData['voucher_balance'] ?? 0;

$stmtBal->close();

$response = [
    "success" => true,
    "today_income" => $today_income,
    "last_7_days_income" => $last_7_days_income,
    "one_month_income" => $one_month_income,
    "yesterday_income" => $yesterday_income, // ✅ নতুন
    "total_income" => $total_income,         // ✅ নতুন
    "balance" => $balance,
    "voucher_balance" => $voucher_balance
];
echo json_encode($response);

$conn->close();
?>
