<?php
include 'db.php'; // your DB connection file

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $user_id = $_POST['user_id'];

    if (empty($user_id)) {
        echo json_encode(["success" => false, "message" => "User ID missing"]);
        exit;
    }

    $stmt = $conn->prepare("SELECT milestone_count FROM referral_bonuses WHERE referrer_user_id = ? ORDER BY id DESC LIMIT 1");
    $stmt->bind_param("s", $user_id);
    $stmt->execute();
    $stmt->bind_result($milestone_count);

    if ($stmt->fetch()) {
        echo json_encode(["success" => true, "milestone_count" => strval($milestone_count)]);
    } else {
        echo json_encode(["success" => false, "message" => "No record found"]);
    }

    $stmt->close();
    $conn->close();
} else {
    echo json_encode(["success" => false, "message" => "Invalid Request"]);
}
?>
