<?php
header('Content-Type: application/json');

// Database connection parameters - !!! IMPORTANT: Use secure configuration for production !!!
include 'db.php';

if ($conn->connect_error) {
    echo json_encode(['success' => false, 'message' => 'Database connection failed: ' . $conn->connect_error]);
    exit;
}

$sql = "SELECT id, user_id, name, phone, wallet, paymentmethod, paymentnumber, amount, status, created_at FROM withdraw_request WHERE status = 'Pending' ORDER BY created_at DESC";
$result = $conn->query($sql);

$requests = [];
if ($result) {
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $requests[] = $row;
        }
        echo json_encode(['success' => true, 'data' => $requests, 'message' => 'Pending requests fetched successfully.']);
    } else {
        echo json_encode(['success' => true, 'data' => [], 'message' => 'No pending requests found.']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Query failed: ' . $conn->error]);
}

$conn->close();
?>