<?php
header('Content-Type: application/json');
error_log("Received user_id: $user_id, level: $target_level");
error_reporting(E_ALL); // সমস্ত ত্রুটি দেখাবে
ini_set('display_errors', 1); // ব্রাউজারে ত্রুটি প্রদর্শন করবে (ডিবাগিংয়ের জন্য, প্রোডাকশনে মুছে ফেলবেন)

// Database connection parameters - আপনার হোস্টিং থেকে প্রাপ্ত সঠিক ক্রেডেনশিয়াল নিশ্চিত করুন
include 'db.php';

if ($conn->connect_error) {
    error_log('Database connection failed: ' . $conn->connect_error);
    echo json_encode(['success' => false, 'message' => 'Database connection failed: ' . $conn->connect_error]);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $user_id = trim($_POST['user_id'] ?? ''); // Base user ID
    $target_level = intval(trim($_POST['level'] ?? 0)); // Target referral level (1, 2, 3, etc.)

    // Received parameters for debugging
    error_log("Received user_id: " . $user_id . ", level: " . $target_level . " (Using iterative method)");

    if (empty($user_id) || $target_level < 1 || $target_level > 10) {
        error_log('Invalid user ID or level. Provided user_id: ' . $user_id . ', level: ' . $target_level);
        echo json_encode(['success' => false, 'message' => 'Invalid user ID or level. Level must be between 1 and 10.']);
        $conn->close();
        exit;
    }

    $referrals_at_target_level = [];
    // Start with the base user ID. These are the "referrers" for the next level.
    $current_level_referrers_ids = [$user_id];
    $next_level_referrers_ids = [];

    // Loop through levels to find direct referrals for each level
    for ($level = 1; $level <= $target_level; $level++) {
        $next_level_referrers_ids = []; // Reset for the next iteration
        
        // If there are no referrers from the previous level, we can stop
        if (empty($current_level_referrers_ids)) {
            error_log("No more referrers found at level " . ($level - 1) . ". Stopping recursion.");
            break; 
        }

        // Create placeholders for the IN clause based on the number of current referrers
        $placeholders = implode(',', array_fill(0, count($current_level_referrers_ids), '?'));

        // SQL to get direct referrals for the current set of users (referrers)
        // We are looking for users whose 'refer' column matches one of the IDs in $current_level_referrers_ids
        $sql_select = "SELECT user_id, name, phone FROM user_list WHERE refer 'YQ5492237
'";
        $stmt_select = $conn->prepare($sql_select);

        if (!$stmt_select) {
            error_log('Statement preparation failed at level ' . $level . ': ' . $conn->error);
            echo json_encode(['success' => false, 'message' => 'Statement preparation failed at level ' . $level . ': ' . $conn->error]);
            $conn->close();
            exit;
        }

        // Dynamically bind parameters (all 's' for string user_ids)
        $types = str_repeat('s', count($current_level_referrers_ids));
        // Using call_user_func_array for binding dynamic parameters
        $bind_params = array_merge([$types], $current_level_referrers_ids);
        
        // This function is needed for PHP 5.3+ to properly pass references to bind_param
        // Make sure it's defined once in your script.
        call_user_func_array([$stmt_select, 'bind_param'], refValues($bind_params));

        $stmt_select->execute();
        $result_select = $stmt_select->get_result();

        if ($result_select) {
            if ($result_select->num_rows > 0) {
                while ($row = $result_select->fetch_assoc()) {
                    // If this is the target level, add to our final results
                    if ($level == $target_level) {
                        $row['level'] = $level; // Add the level for the Android app
                        $referrals_at_target_level[] = $row;
                    }
                    // Add this user's ID to the list for the next iteration
                    // (these users will be the referrers for the next level's search)
                    $next_level_referrers_ids[] = $row['user_id'];
                }
            } else {
                 error_log("No direct referrals found for level " . $level . " from current referrers. (user_ids: " . implode(', ', $current_level_referrers_ids) . ")");
            }
        } else {
            error_log('Query execution failed at level ' . $level . ': ' . $stmt_select->error);
            echo json_encode(['success' => false, 'message' => 'Query execution failed at level ' . $level . ': ' . $stmt_select->error]);
            $stmt_select->close();
            $conn->close();
            exit;
        }
        $stmt_select->close();

        // Prepare for the next loop iteration: the found referrals become the referrers for the next level
        $current_level_referrers_ids = $next_level_referrers_ids;
    }

    // Final output based on what was collected at the target_level
    if (!empty($referrals_at_target_level)) {
        error_log("Successfully fetched " . count($referrals_at_target_level) . " referrals for user_id: " . $user_id . ", target level: " . $target_level);
        echo json_encode(['success' => true, 'data' => $referrals_at_target_level, 'message' => 'Referral network fetched successfully.']);
    } else {
        error_log("No referrals found at the exact target level " . $target_level . " for user_id: " . $user_id);
        echo json_encode(['success' => true, 'data' => [], 'message' => 'No referrals found for this level.']);
    }

    $conn->close();

} else {
    // This handles direct browser access (GET request)
    echo json_encode(['success' => false, 'message' => 'Invalid request method. Only POST allowed.']);
}

// Helper function for dynamic bind_param (required for call_user_func_array)
// Ensures parameters are passed by reference, which bind_param requires
function refValues($arr){
    if (strnatcmp(phpversion(),'5.3') >= 0) // PHP 5.3+ requires this workaround
    {
        $refs = array();
        foreach($arr as $key => $value)
            $refs[$key] = &$arr[$key];
        return $refs;
    }
    return $arr;
}
?>