<?php
header('Content-Type: application/json');

include 'db.php';

if ($conn->connect_error) {
    echo json_encode(['success' => false, 'message' => 'Database connection failed: ' . $conn->connect_error]);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $user_id = trim($_POST['phone'] ?? '');
    $status = trim($_POST['status'] ?? ''); // 'Pending', 'Verified', 'Cancelled'

    if (empty($user_id)) {
        echo json_encode(['success' => false, 'message' => 'User ID is required.']);
        $conn->close();
        exit;
    }

    // Validate the status parameter
    if (!in_array($status, ['Pending', 'Verified', 'Cancelled'])) {
        echo json_encode(['success' => false, 'message' => 'Invalid status parameter.']);
        $conn->close();
        exit;
    }

    // Prepare the SQL query
    $sql = "SELECT *
            FROM marketting_list 
            WHERE phone = ? AND status = ? 
            ORDER BY created_at DESC";

    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        echo json_encode(['success' => false, 'message' => 'Query preparation failed: ' . $conn->error]);
        $conn->close();
        exit;
    }

    // Bind parameters and execute
    $stmt->bind_param("ss", $user_id, $status);
    $stmt->execute();
    $result = $stmt->get_result();

    $requests = [];
    if ($result) {
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $requests[] = $row;
            }
            echo json_encode(['success' => true, 'data' => $requests, 'message' => 'Requests fetched successfully.']);
        } else {
            echo json_encode(['success' => true, 'data' => [], 'message' => 'No requests found for this status.']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Query execution failed: ' . $stmt->error]);
    }

    $stmt->close();
    $conn->close();

} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method. Only POST allowed.']);
}
?>