<?php
// এই স্ক্রিপ্টটি অ্যাডমিন প্যানেল অ্যাপ থেকে রেফারেল বোনাস রিকোয়েস্টগুলো
// দেখা, ভেরিফাই করা এবং বাতিল করার জন্য ব্যবহৃত হয়।

// CORS হেডার (যদি আপনার অ্যাডমিন অ্যাপ অন্য ডোমেইন থেকে অ্যাক্সেস করে)
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include 'dbs.php';
if (!$con) {
    echo json_encode(["status" => "error", "message" => "ডাটাবেজ সংযোগ ব্যর্থ: " . mysqli_connect_error()]);
    exit;
}

date_default_timezone_set('Asia/Dhaka');
$time_format = date("Y-m-d H:i:s");

// GET রিকোয়েস্ট: বোনাস রিকোয়েস্টগুলো আনা
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    $status_filter = isset($_GET['status']) ? $_GET['status'] : 'pending'; // ডিফল্ট 'pending'

    $sql = "SELECT id, referrer_user_id, referrer_name, referrer_phone, milestone_count, bonus_amount, request_date, status, verification_date
            FROM referral_bonuses WHERE status = ? ORDER BY request_date DESC";

    $stmt = $con->prepare($sql);
    if (!$stmt) {
        echo json_encode(["status" => "error", "message" => "প্রস্তুতি ব্যর্থ (ডেটা আনা): " . $con->error]);
        $con->close();
        exit;
    }
    $stmt->bind_param("s", $status_filter);
    $stmt->execute();
    $result = $stmt->get_result();

    $bonuses = [];
    while ($row = $result->fetch_assoc()) {
        $bonuses[] = $row;
    }

    echo json_encode(["status" => "success", "data" => $bonuses]);
    $stmt->close();
}
// POST রিকোয়েস্ট: বোনাস রিকোয়েস্ট ভেরিফাই বা বাতিল করা
elseif ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // JSON ইনপুট ডেটা নিন
    $data = json_decode(file_get_contents("php://input"), true);

    $bonus_id = $data['bonus_id'] ?? null;
    $action = $data['action'] ?? null; // 'verify' বা 'reject'

    if (!$bonus_id || !$action) {
        echo json_encode(["status" => "error", "message" => "অসম্পূর্ণ ডেটা: bonus_id এবং action প্রয়োজন।"]);
        $con->close();
        exit;
    }

    if ($action == 'verify') {
        // বোনাস রিকোয়েস্টের বিস্তারিত তথ্য নিন এবং স্ট্যাটাস 'pending' কিনা চেক করুন
        $stmt = $con->prepare("SELECT referrer_user_id, bonus_amount, status FROM referral_bonuses WHERE id = ? AND status = 'pending'");
        if (!$stmt) {
            echo json_encode(["status" => "error", "message" => "প্রস্তুতি ব্যর্থ (ভেরিফাই চেক): " . $con->error]);
            $con->close();
            exit;
        }
        $stmt->bind_param("i", $bonus_id);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $bonus_row = $result->fetch_assoc();
            $referrer_user_id = $bonus_row['referrer_user_id'];
            $bonus_amount = $bonus_row['bonus_amount'];

            // রেফারারের ব্যালেন্সে টাকা যোগ করুন
            $updateUserBalanceStmt = $con->prepare("UPDATE user_list SET balance = balance + ? WHERE user_id = ?");
            if (!$updateUserBalanceStmt) {
                error_log("প্রস্তুতি ব্যর্থ (ইউজার ব্যালেন্স আপডেট): " . $con->error);
                echo json_encode(["status" => "error", "message" => "ইউজার ব্যালেন্স আপডেট করতে ব্যর্থ।"]);
                $con->close();
                exit;
            }
            $updateUserBalanceStmt->bind_param("ds", $bonus_amount, $referrer_user_id);
            $updateUserBalanceStmt->execute();
            $updateUserBalanceStmt->close();

            // কমিশনে রেকর্ড করুন (বোনাস হিসেবে)
            $insertCommissionStmt = $con->prepare("INSERT INTO commissions (user_id, from_user_id, level, amount, type, source, created_at) VALUES (?, ?, ?, ?, 'bonus', 'admin_verified_referral_milestone', ?)");
            if (!$insertCommissionStmt) {
                error_log("প্রস্তুতি ব্যর্থ (কমিশন ইনসার্ট): " . $con->error);
                echo json_encode(["status" => "error", "message" => "কমিশন রেকর্ড করতে ব্যর্থ।"]);
                $con->close();
                exit;
            }
            $level_for_bonus = 0; // বোনাসের জন্য লেভেল 0 বা অন্য কোনো নির্দিষ্ট মান
            $insertCommissionStmt->bind_param("ssiss", $referrer_user_id, $referrer_user_id, $level_for_bonus, $bonus_amount, $time_format);
            $insertCommissionStmt->execute();
            $insertCommissionStmt->close();

            // referral_bonuses টেবলে স্ট্যাটাস আপডেট করুন
            $updateBonusStatusStmt = $con->prepare("UPDATE referral_bonuses SET status = 'verified', verification_date = ? WHERE id = ?");
            if (!$updateBonusStatusStmt) {
                error_log("প্রস্তুতি ব্যর্থ (বোনাস স্ট্যাটাস আপডেট): " . $con->error);
                echo json_encode(["status" => "error", "message" => "বোনাস স্ট্যাটাস আপডেট করতে ব্যর্থ।"]);
                $con->close();
                exit;
            }
            $updateBonusStatusStmt->bind_param("si", $time_format, $bonus_id);
            $updateBonusStatusStmt->execute();
            $updateBonusStatusStmt->close();

            echo json_encode(["status" => "success", "message" => "বোনাস সফলভাবে ভেরিফাই করা হয়েছে এবং ব্যালেন্সে যোগ হয়েছে।"]);
        } else {
            echo json_encode(["status" => "error", "message" => "পেন্ডিং বোনাস রিকোয়েস্ট পাওয়া যায়নি অথবা ইতিমধ্যেই প্রসেস করা হয়েছে।"]);
        }
        $stmt->close();
    } elseif ($action == 'reject') {
        // শুধু স্ট্যাটাস রিজেক্ট করুন
        $updateBonusStatusStmt = $con->prepare("UPDATE referral_bonuses SET status = 'rejected', verification_date = ? WHERE id = ?");
        if (!$updateBonusStatusStmt) {
            error_log("প্রস্তুতি ব্যর্থ (রিজেক্ট স্ট্যাটাস আপডেট): " . $con->error);
            echo json_encode(["status" => "error", "message" => "রিকোয়েস্ট বাতিল করতে ব্যর্থ।"]);
            $con->close();
            exit;
        }
        $updateBonusStatusStmt->bind_param("si", $time_format, $bonus_id);
        $updateBonusStatusStmt->execute();
        $updateBonusStatusStmt->close();
        echo json_encode(["status" => "success", "message" => "বোনাস রিকোয়েস্ট বাতিল করা হয়েছে।"]);
    } else {
        echo json_encode(["status" => "error", "message" => "অবৈধ অ্যাকশন।"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "অবৈধ অনুরোধ পদ্ধতি।"]);
}

$con->close();
?>