<?php

date_default_timezone_set('Asia/Dhaka');
$time_format = date("Y-m-d H:i:s");
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $transaction = $_POST['transaction'] ?? '';
    $user_id = $_POST['user_id'] ?? '';

    if (empty($transaction)) {
        echo json_encode(["status" => "error", "message" => "অনুগ্রহ করে একটি সঠিক Transaction ID প্রদান করুন।"]);
        exit;
    }

    include 'dbs.php';
    if (!$con) {
        echo json_encode(["status" => "error", "message" => "ডেটাবেস কানেকশন ব্যর্থ হয়েছে।"]);
        exit;
    }

    // Check if transaction exists
    $stmt = $con->prepare("SELECT amount, used FROM trxid_table WHERE txnId = ?");
    $stmt->bind_param("s", $transaction);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        echo json_encode(["status" => "error", "message" => "Transaction ID not found"]);
    } else {
        $row = $result->fetch_assoc();
        $amount = $row['amount'];
        $used = $row['used'];

        if ($used == 1) {
            echo json_encode(["status" => "error", "message" => "Transaction Used earlier"]);
        } else {
            // Update user balance
            $update = $con->prepare("UPDATE user_list SET voucher_balance = voucher_balance + ? WHERE user_id = ?");
            $update->bind_param("ds", $amount, $user_id);
            $update->execute();

            // Mark transaction as used
            $markUsed = $con->prepare("UPDATE trxid_table SET used = 1 WHERE txnId = ?");
            $markUsed->bind_param("s", $transaction);
            $markUsed->execute();
            
            
            // ✅ Step 4: Insert into voucher_balance_table
            $log = $con->prepare("INSERT INTO voucher_balance_table (user_id, txn_id, amount,created_at) VALUES (?, ?, ?,?)");
            $log->bind_param("ssds", $user_id, $transaction, $amount,$time_format);
            $log->execute();

            echo json_encode(["status" => "success", "message" => "Payment Successful. Voucher balance updated."]);

            $update->close();
            $markUsed->close();
        }
    }

    $stmt->close();
    $con->close();
}
?>
